package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

/**
 * 	ALTER TABLE PHR_CHEM_LAB ADD "REPORT_TEXT" CLOB;
 *	ALTER TABLE PHR_CHEM_LAB ADD "PHYSICIAN" TIMESTAMP (6);
 *	ALTER TABLE PHR_CHEM_LAB ADD "PATHOLOGIST" TIMESTAMP (6);
 *
 * 
*/

public class StagePathology extends StageEntity  {
	public String surgeonPhysician;
	public String pathologist;
	public String reportText;    
    public String typeOfReport;
    public String specimen;
    public Date collectedDateTimePrecise;
    public String collectedDateTimeImprecise;
    public String submittedby;
    public String performingLocation;
    public Date completedDateTimePrecise;
    public String completedDateTimeImprecise;
	
    public StagePathology() {
    	super();
    }
    
    public StagePathology(Long oplock, Date createdDate, Date modifiedDate,
			String icn, String stationNumber, Long requestMsgCtrlId) {
        super();
        this.oplock = oplock;
        this.createdDate = createdDate;
        this.modifiedDate = modifiedDate;
        this.icn = icn;
        this.stationNumber = stationNumber;
        this.requestMsgCtrlId = requestMsgCtrlId;
	}
    
	public String getSurgeonPhysician() {
		return surgeonPhysician;
	}
	public void setSurgeonPhysician(String surgeonPhysician) {
		this.surgeonPhysician = surgeonPhysician;
	}
	public String getPathologist() {
		return pathologist;
	}
	public void setPathologist(String pathologist) {
		this.pathologist = pathologist;
	}
	public String getReportText() {
		return reportText;
	}
	public void setReportText(String reportText) {
		this.reportText = reportText;
	}
	public String getTypeOfReport() {
		return typeOfReport;
	}
	public void setTypeOfReport(String typeOfReport) {
		this.typeOfReport = typeOfReport;
	}
	public String getSpecimen() {
		return specimen;
	}
	public void setSpecimen(String specimen) {
		this.specimen = specimen;
	}
	public Date getCollectedDateTimePrecise() {
		return collectedDateTimePrecise;
	}
	public void setCollectedDateTimePrecise(Date collectedDateTimePrecise) {
		this.collectedDateTimePrecise = collectedDateTimePrecise;
	}
	public String getCollectedDateTimeImprecise() {
		return collectedDateTimeImprecise;
	}
	public void setCollectedDateTimeImprecise(String collectedDateTimeImprecise) {
		this.collectedDateTimeImprecise = collectedDateTimeImprecise;
	}
	public String getSubmittedby() {
		return submittedby;
	}
	public void setSubmittedby(String submittedby) {
		this.submittedby = submittedby;
	}
	public String getPerformingLocation() {
		return performingLocation;
	}
	public void setPerformingLocation(String performingLocation) {
		this.performingLocation = performingLocation;
	}

	public Date getCompletedDateTimePrecise() {
		return completedDateTimePrecise;
	}

	public void setCompletedDateTimePrecise(Date completedDateTimePrecise) {
		this.completedDateTimePrecise = completedDateTimePrecise;
	}

	public String getCompletedDateTimeImprecise() {
		return completedDateTimeImprecise;
	}

	public void setCompletedDateTimeImprecise(String completedDateTimeImprecise) {
		this.completedDateTimeImprecise = completedDateTimeImprecise;
	}
	
	public void setAK(StageEntityAK ak) {
		this.icn = ak.getIcn();
		// Station number is excluded because it comes from the response not the
		// request
		// in the case of immunization.

		// this.stationNumber=ak.getStationNumber();
		this.requestMsgCtrlId = ak.getRequestMsgCtrlId();
		this.responseMsgCtrlId = ak.getResponseMsgCtrlId();
	}
	
	public String toCompare() {
		return "" + 
		getCollectedDateTimePrecise() +
		getCompletedDateTimePrecise() +
		getPathologist() +
		getPerformingLocation() + 
		StringUtils.deleteWhitespace(getReportText()) +
		getSpecimen() +
		getSubmittedby() +
		getSurgeonPhysician() +
		getTypeOfReport();
	}
}